/*
 *	Floating point for base 2 to 36
 *	Programmed by Michael Punter
 *	Version 3
 */
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <ctype.h>

// Bit length of mantisa
#define DMANTISSA	52.0
#define LDMANTISSA	63.0

class fbase
{
	private:
		int Base;
		char BasePoint;
		bool DspSci;
		double fsplitb(double Decimal, int &Point);
		double fjoinb(double Decimal, int Point);
		int precisionb(void);
		long double fsplitlb(long double Decimal, int &Point);
		long double fjoinlb(long double Decimal, int Point);
		int precisionlb(void);
		int remove0s(char *strBase);
	public:
		fbase()
		{
			Base = 10;
			BasePoint = '.';
			DspSci = false;
		}
		fbase(int iBase)
		{
			setbase(iBase);
			BasePoint = '.';
			DspSci = false;
		}
		fbase(int iBase, char iBasePoint)
		{
			setbase(iBase);
			setbasepoint(iBasePoint);
			DspSci = false;
		}
		void setbase(int iBase)
		{
			if(iBase >= 2 && iBase <= 36)
				Base = iBase;
			else
				Base = 10;
		}
		int getbase(void) { return(Base); }
		void setbasepoint(char iBasePoint)
		{
			if(!iscntrl(iBasePoint) && !isalnum(iBasePoint))
				BasePoint = iBasePoint;
			else
				BasePoint = '.';
		}
		char getbasepoint(void) { return(BasePoint); }
		void setdspsci(bool iDspSci) { DspSci = iDspSci; }
		bool getdspsci(void) { return(DspSci); }
		char *ftoab(double Decimal, char *strBase, int StrLen);
		double atofb(char *strBase);
		double roundb(double Decimal, int Prec);
		char *ftoalb(long double Decimal, char *strBase, int StrLen);
		long double atoflb(char *strBase);
		long double roundlb(long double Decimal, int Prec);
};
