/*
 *	Floating point for base 2 to 36
 *	Programmed by Michael Punter
 *	Version 3
 */
#include "fbase.h"

// Convert floating double number to string in given base.
//	Inputs:
//		Double value to convert
//		String to hold convertion
//		Maximum length of string
//	Return:
//		Pointer to string
//	Error report:
//		Overflow (OF)
char *fbase::ftoab(double Decimal, char *strBase, int StrLen)
{
	int i = 0, iDec, Point, PointFlag = true, Prec;

	if(StrLen <= 0)
		return(NULL);
	// Creates Buffer dynamic variable
	char *Buffer = new char[StrLen + 2];
	char *Exponent = new char[StrLen + 2];
	if(Decimal < 0.0)
	{
		Decimal = -Decimal;
		Buffer[0] = '-';
		i++;
	}
	Prec = precisionb();
	if(StrLen >= Prec)
	{
		if(Base != 2 && Base != 4 && Base != 8 && Base != 16 && Base != 32)
			Decimal = roundb(Decimal, Prec);
	}
	else
		Decimal = roundb(Decimal, StrLen);
	Decimal = fsplitb(Decimal, Point);
	iDec = Point;
	if(iDec < 0)
	{
		iDec = -iDec;
		iDec += 1;
	}
	if(iDec >= StrLen || DspSci)
	{
//		Create Scientific
		for(; Prec >= 0 && i < StrLen; i++, Prec--)
		{
			iDec = Decimal;
			itoa(iDec, Buffer + i, Base);
			Decimal -= iDec;
			Decimal *= Base;
			if(PointFlag)
			{
				if(++i >= StrLen)
					break;
				Buffer[i] = BasePoint;
				Buffer[i + 1] = NULL;
				PointFlag = false;
			}
		}
		iDec = remove0s(Buffer);
		i = 0;
		Exponent[i++] = '^';
		if(Point < 0)
		{
			Exponent[i++] = '-';
			Point = -Point;
		}
		itoa(Point, Exponent + i, Base);
		i = strlen(Exponent);
		if((iDec + i) > StrLen)
		{
			if((StrLen - i) <= 0)
			{
				strcpy(Exponent, "OF");
				Buffer[0] = NULL;
			}
			else
				Buffer[StrLen - i] = NULL;
		}
		strcat(Buffer, Exponent);
	}
	else
	{
		for(; i < StrLen; i++)
		{
			if(Point < 0 || Prec < 0)
			{
				iDec = 0;
				itoa(iDec, Buffer + i, Base);
			}
			else
			{
				iDec = Decimal;
				itoa(iDec, Buffer + i, Base);
				Decimal -= iDec;
				Decimal *= Base;
				Prec--;
			}
			if(Point <= 0 && PointFlag)
			{
				if(++i >= StrLen)
					break;
				Buffer[i] = BasePoint;
				Buffer[i + 1] = NULL;
				PointFlag = false;
			}
			if(Point > 0)
				Point--;
			else if(Point < 0)
				Point++;
		}
		remove0s(Buffer);
	}
	strcpy(strBase, Buffer);
	delete Exponent;
	delete Buffer;
	return(strupr(strBase));
}
//---------------------------------------------------------------------------
// Convert string in given base to floating double number.
//	Inputs:
//		String value to convert
//	Return:
//		Double
//	Accepted string format
//		[ws] [sn] [ddd] [.] [ddd] [fmt[sn]ddd]
//	where:
//		[ws]	=	optional whitespace
//		[sn]	=	optional sign (+ or -)
//		[ddd]	=	optional digits
//		[fmt]	=	optional ^
//		[.]	=	optional base point
double fbase::atofb(char *strBase)
{
	long double Decimal = 0.0;
	int iDec, Point = 0, PointFlag = false, Neg = false;
	char *BufPtr;

	// Creates Buffer dynamic variable
	char *Buffer = new char[strlen(strBase) + 1];
	BufPtr = Buffer;
	strcpy(BufPtr, strBase);
	strupr(BufPtr);
	while(isspace(*BufPtr))
		BufPtr++;
	if(*BufPtr == '-' || *BufPtr == '+')
	{
		if(*BufPtr == '-')
			Neg = true;
		BufPtr++;
	}
	while(isspace(*BufPtr))
		BufPtr++;
	for(; *BufPtr; BufPtr++)
	{
		if(*BufPtr == BasePoint)
		{
			PointFlag = true;
		}
		else
		{
			if(*BufPtr >= 'A' && *BufPtr < ('A' + (Base - 10)))
				*BufPtr -= (char)7;
			if(*BufPtr >= '0' && *BufPtr < ('0' + Base))
			{
				Decimal *= Base;
				iDec = *BufPtr - '0';
				Decimal += iDec;
				if(PointFlag)
					Point--;
			}
			else
				break;
		}
	}
	Decimal = fjoinb(Decimal, Point);
	if(Neg)
		Decimal = -Decimal;
	while(isspace(*BufPtr))
		BufPtr++;
//	Code for Exponent
	if(*BufPtr == '^')
	{
		BufPtr++;
		Neg = false;
		while(isspace(*BufPtr))
			BufPtr++;
		if(*BufPtr == '-' || *BufPtr == '+')
		{
			if(*BufPtr == '-')
				Neg = true;
			BufPtr++;
		}
		while(isspace(*BufPtr))
			BufPtr++;
		iDec = 0;
		for(; *BufPtr; BufPtr++)
		{
			if(*BufPtr >= 'A' && *BufPtr < ('A' + (Base - 10)))
				*BufPtr -= (char)7;
			if(*BufPtr >= '0' && *BufPtr < ('0' + Base))
			{
				iDec *= Base;
				iDec += *BufPtr - '0';
			}
			else
				break;
		}
		if(Neg)
			iDec = -iDec;
		Decimal = fjoinb(Decimal, iDec);
	}
	delete Buffer;
	return(Decimal);
}
//---------------------------------------------------------------------------
double fbase::roundb(double Decimal, int Prec)
{
	int Point, Neg = false;

	if(Decimal == 0.0)
		return(Decimal);
	if(Decimal < 0.0)
	{
		Decimal = -Decimal;
		Neg = true;
	}
	fsplitb(Decimal, Point);
	Decimal += (double)(Base / 2) / pow(Base, (Prec + 1) - Point);
	if(Neg)
		Decimal = -Decimal;
	return(Decimal);
}
//---------------------------------------------------------------------------
// Convert floating long double number to string in given base.
//	Inputs:
//		Long double value to convert
//		String to hold convertion
//		Maximum length of string
//	Return:
//		Pointer to string
//	Error report:
//		Overflow (OF)
char *fbase::ftoalb(long double Decimal, char *strBase, int StrLen)
{
	int i = 0, iDec, Point, PointFlag = true, Prec;

	if(StrLen <= 0)
		return(NULL);
	// Creates Buffer dynamic variable
	char *Buffer = new char[StrLen + 2];
	char *Exponent = new char[StrLen + 2];
	if(Decimal < 0.0L)
	{
		Decimal = -Decimal;
		Buffer[0] = '-';
		i++;
	}
	Prec = precisionlb();
	if(StrLen >= Prec)
	{
		if(Base != 2 && Base != 4 && Base != 8 && Base != 16 && Base != 32)
			Decimal = roundlb(Decimal, Prec);
	}
	else
		Decimal = roundlb(Decimal, StrLen);
	Decimal = fsplitlb(Decimal, Point);
	iDec = Point;
	if(iDec < 0)
	{
		iDec = -iDec;
		iDec += 1;
	}
	if(iDec >= StrLen || DspSci)
	{
//		Create Scientific
		for(; Prec >= 0 && i < StrLen; i++, Prec--)
		{
			iDec = Decimal;
			itoa(iDec, Buffer + i, Base);
			Decimal -= iDec;
			Decimal *= Base;
			if(PointFlag)
			{
				if(++i >= StrLen)
					break;
				Buffer[i] = BasePoint;
				Buffer[i + 1] = NULL;
				PointFlag = false;
			}
		}
		iDec = remove0s(Buffer);
		i = 0;
		Exponent[i++] = '^';
		if(Point < 0)
		{
			Exponent[i++] = '-';
			Point = -Point;
		}
		itoa(Point, Exponent + i, Base);
		i = strlen(Exponent);
		if((iDec + i) > StrLen)
		{
			if((StrLen - i) <= 0)
			{
				strcpy(Exponent, "OF");
				Buffer[0] = NULL;
			}
			else
				Buffer[StrLen - i] = NULL;
		}
		strcat(Buffer, Exponent);
	}
	else
	{
		for(; i < StrLen; i++)
		{
			if(Point < 0 || Prec < 0)
			{
				iDec = 0;
				itoa(iDec, Buffer + i, Base);
			}
			else
			{
				iDec = Decimal;
				itoa(iDec, Buffer + i, Base);
				Decimal -= iDec;
				Decimal *= Base;
				Prec--;
			}
			if(Point <= 0 && PointFlag)
			{
				if(++i >= StrLen)
					break;
				Buffer[i] = BasePoint;
				Buffer[i + 1] = NULL;
				PointFlag = false;
			}
			if(Point > 0)
				Point--;
			else if(Point < 0)
				Point++;
		}
		remove0s(Buffer);
	}
	strcpy(strBase, Buffer);
	delete Exponent;
	delete Buffer;
	return(strupr(strBase));
}
//---------------------------------------------------------------------------
// Convert string in given base to floating long double number.
//	Inputs:
//		String value to convert
//	Return:
//		Long double
//	Accepted string format
//		[ws] [sn] [ddd] [.] [ddd] [fmt[sn]ddd]
//	where:
//		[ws]	=	optional whitespace
//		[sn]	=	optional sign (+ or -)
//		[ddd]	=	optional digits
//		[fmt]	=	optional ^
//		[.]	=	optional base point
long double fbase::atoflb(char *strBase)
{
	long double Decimal = 0.0L;
	int iDec, Point = 0, PointFlag = false, Neg = false;
	char *BufPtr;

	// Creates Buffer dynamic variable
	char *Buffer = new char[strlen(strBase) + 1];
	BufPtr = Buffer;
	strcpy(BufPtr, strBase);
	strupr(BufPtr);
	while(isspace(*BufPtr))
		BufPtr++;
	if(*BufPtr == '-' || *BufPtr == '+')
	{
		if(*BufPtr == '-')
			Neg = true;
		BufPtr++;
	}
	while(isspace(*BufPtr))
		BufPtr++;
	for(; *BufPtr; BufPtr++)
	{
		if(*BufPtr == BasePoint)
		{
			PointFlag = true;
		}
		else
		{
			if(*BufPtr >= 'A' && *BufPtr < ('A' + (Base - 10)))
				*BufPtr -= (char)7;
			if(*BufPtr >= '0' && *BufPtr < ('0' + Base))
			{
				Decimal *= Base;
				iDec = *BufPtr - '0';
				Decimal += iDec;
				if(PointFlag)
					Point--;
			}
			else
				break;
		}
	}
	Decimal = fjoinlb(Decimal, Point);
	if(Neg)
		Decimal = -Decimal;
	while(isspace(*BufPtr))
		BufPtr++;
//	Code for Exponent
	if(*BufPtr == '^')
	{
		BufPtr++;
		Neg = false;
		while(isspace(*BufPtr))
			BufPtr++;
		if(*BufPtr == '-' || *BufPtr == '+')
		{
			if(*BufPtr == '-')
				Neg = true;
			BufPtr++;
		}
		while(isspace(*BufPtr))
			BufPtr++;
		iDec = 0;
		for(; *BufPtr; BufPtr++)
		{
			if(*BufPtr >= 'A' && *BufPtr < ('A' + (Base - 10)))
				*BufPtr -= (char)7;
			if(*BufPtr >= '0' && *BufPtr < ('0' + Base))
			{
				iDec *= Base;
				iDec += *BufPtr - '0';
			}
			else
				break;
		}
		if(Neg)
			iDec = -iDec;
		Decimal = fjoinlb(Decimal, iDec);
	}
	delete Buffer;
	return(Decimal);
}
//---------------------------------------------------------------------------
long double fbase::roundlb(long double Decimal, int Prec)
{
	int Point, Neg = false;

	if(Decimal == 0.0L)
		return(Decimal);
	if(Decimal < 0.0L)
	{
		Decimal = -Decimal;
		Neg = true;
	}
	fsplitlb(Decimal, Point);
	Decimal += (long double)(Base / 2) / powl(Base, (Prec + 1) - Point);
	if(Neg)
		Decimal = -Decimal;
	return(Decimal);
}
//---------------------------------------------------------------------------
double fbase::fsplitb(double Decimal, int &Point)
{
	if(Decimal == 0.0)
		Point = 0;
	else if(Decimal < 1.0)
		for(Point = 0; Decimal < 1.0; Point--)
			Decimal *= Base;
	else
		for(Point = 0; Decimal >= Base; Point++)
			Decimal /= Base;
	return(Decimal);
}
//---------------------------------------------------------------------------
double fbase::fjoinb(double Decimal, int Point)
{
	if(Point > 0)
		for(; Point; Point--)
			Decimal *= Base;
	else if(Point < 0)
		for(; Point; Point++)
			Decimal /= Base;
	return(Decimal);
}
//---------------------------------------------------------------------------
int fbase::precisionb(void)
{
	return(DMANTISSA / (log10(Base) / log10(2.0)));
}
//---------------------------------------------------------------------------
long double fbase::fsplitlb(long double Decimal, int &Point)
{
	if(Decimal == 0.0L)
		Point = 0;
	else if(Decimal < 1.0L)
		for(Point = 0; Decimal < 1.0L; Point--)
			Decimal *= Base;
	else
		for(Point = 0; Decimal >= Base; Point++)
			Decimal /= Base;
	return(Decimal);
}
//---------------------------------------------------------------------------
long double fbase::fjoinlb(long double Decimal, int Point)
{
	if(Point > 0)
		for(; Point; Point--)
			Decimal *= Base;
	else if(Point < 0)
		for(; Point; Point++)
			Decimal /= Base;
	return(Decimal);
}
//---------------------------------------------------------------------------
int fbase::precisionlb(void)
{
	return(LDMANTISSA / (log10(Base) / log10(2.0)));
}
//---------------------------------------------------------------------------
int fbase::remove0s(char *strBase)
{
	int i;

	if(strchr(strBase, BasePoint))
	{
		i = strlen(strBase) - 1;
		for(; *(strBase + i) == '0'; i--)
			*(strBase + i) = NULL;
		if(*(strBase + i) == BasePoint)
			*(strBase + i) = NULL;
	}
	return(strlen(strBase));
}
//---------------------------------------------------------------------------
