/*
 *	Dozenal calculator
 *	Programmed by Michael Punter
 *	Version 2.2.1
 */
//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "Unit1.h"
#include "fbase.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm1 *Form1;
fbase Zen(12, ';');
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
	: TForm(Owner)
{
	HintFlag = false;
	FirstOp = true;
	SecondOp = false;
	Str0Flag = false;
	Exponent = false;
	Dozimal = false;
	DecimalFlag = false;
	BraceFlag = false;
	IntnatFlag = 0;
	DspNum = 0.0L;
	Memo1->Text = strcpy(StrMemo, "0");
	ChrtoStr[1] = NULL;
	Label1->Caption = "";
	Label2->Caption = "";
	ModifyMode();
}
//---------------------------------------------------------------------------
void TForm1::Calculate(char Button)
{
	char *ptr, Tempstr[16];
	int Len, err;

	switch(Button)
	{
		case B_1: case B_2: case B_3: case B_4:
		case B_5: case B_6: case B_7: case B_8:
		case B_9: case B_TEN: case B_ELV: case B_0:
		case B_DOZIMAL: case B_EXP:
			if(Str0Flag)
				strcpy(StrMemo, "0");
			Str0Flag = false;
			if((Len = strlen(StrMemo)) >= 14)
					break;
			if(Button == B_EXP)
			{
				if(Exponent)
					break;
				Exponent = true;
			}
			else if(Button == B_DOZIMAL)
			{
				if(Dozimal)
					break;
				if(DecimalFlag)
					Button = B_DECIMAL;
				Dozimal = true;
			}
			else if(Len <= 2)
			{
				if(Len == 1 && StrMemo[0] == '0')
					StrMemo[0] = NULL;
				else if(StrMemo[0] == '-' && StrMemo[1] == '0')
					StrMemo[1] = NULL;
			}
			Tempstr[0] = Button;
			Tempstr[1] = NULL;
			Memo1->Text = strcat(StrMemo, Tempstr);
			DspNum = Zen.atoflb(Memo1->Text.c_str());
			SecondOp = true;
			break;
		case B_DEL:
			if(Str0Flag)
				break;
			Len = strlen(StrMemo);
			if(Len == 1 || (Len == 2 && StrMemo[0] == '-'))
			{
				Memo1->Text = strcpy(StrMemo, "0");
				break;
			}
			if(StrMemo[Len - 1] == B_EXP)
				Exponent = false;
			else if(StrMemo[Len - 1] == B_DOZIMAL)
				Dozimal = false;
			StrMemo[Len - 1] = NULL;
			Memo1->Text = StrMemo;
			DspNum = Zen.atoflb(Memo1->Text.c_str());
			break;
		case B_MINUS:
			if(Str0Flag)
				strcpy(StrMemo, "0");
			Str0Flag = false;
			if((Len = strlen(StrMemo)) >= 14)
				break;
			if(Exponent)
			{
				ptr = strchr(StrMemo, '^');
				strcpy(Tempstr, StrMemo);
				Tempstr[ptr - StrMemo + 1] = NULL;
				if(StrMemo[ptr - StrMemo + 1] == '-')
					strcat(Tempstr, StrMemo + (ptr - StrMemo + 2));
				else
				{
					strcat(Tempstr, "-");
					strcat(Tempstr, StrMemo + (ptr - StrMemo + 1));
				}
			}
			else
			{
				if(StrMemo[0] == '-')
					strcpy(Tempstr, (StrMemo + 1));
				else
				{
					Tempstr[0] = '-';
					Tempstr[1] = NULL;
					strcat(Tempstr, StrMemo);
				}
			}
			Memo1->Text = strcpy(StrMemo, Tempstr);
			DspNum = Zen.atoflb(Memo1->Text.c_str());
			SecondOp = true;
			break;
		case B_AC:
			FirstOp = true;
			SecondOp = false;
			Str0Flag = false;
			Exponent = false;
			Dozimal = false;
			BraceFlag = false;
			DspNum = 0.0L;
			Memo1->Text = strcpy(StrMemo, "0");
			Label2->Caption = "";
			break;
		case B_DIV: case B_MULT: case B_SUB: case B_PLUS:
		case B_EQUALS: case B_CBRACE:
			Str0Flag = true;
			Exponent = false;
			Dozimal = false;
			if(FirstOp)
			{
				if(Button != B_EQUALS && Button != B_CBRACE)
				{
					FirstNum = DspNum;
					OpKey = Button;
					ChrtoStr[0] = Button;
					Label2->Caption = ChrtoStr;
					FirstOp = false;
					SecondOp = true;
				}
				else
				{
					if(BraceFlag)
						CloseBrace(Button);
					else
					{
						Memo1->Text = Zen.ftoalb(DspNum, StrMemo, 14);
						Label2->Caption = "";
					}
					FirstOp = true;
					BraceFlag = false;
				}
			}
			else if(SecondOp)
			{
				SecondNum = DspNum;
				if((err = Operation(OpKey)) == true)
						strcpy(StrMemo, "Divide by zero!");
				else
					Zen.ftoalb(FirstNum, StrMemo, 14);
				DspNum = FirstNum;
				Memo1->Text = StrMemo;
				if(Button != B_EQUALS && Button != B_CBRACE && !err)
				{
					OpKey = Button;
					ChrtoStr[0] = Button;
					Label2->Caption = ChrtoStr;
				}
				else
				{
					if(BraceFlag)
						CloseBrace(Button);
					else
						Label2->Caption = "";
					FirstOp = true;
					BraceFlag = false;
				}
				SecondOp = false;
			}
			else
			{
				if(Button == OpKey && Button != B_EQUALS)
				{
					if((err = Operation(OpKey)) == true)
							strcpy(StrMemo, "Divide by zero!");
					else
						Zen.ftoalb(FirstNum, StrMemo, 14);
					DspNum = FirstNum;
					Memo1->Text = StrMemo;
				}
				if(Button != B_EQUALS && Button != B_CBRACE && !err)
				{
					OpKey = Button;
					ChrtoStr[0] = Button;
					Label2->Caption = ChrtoStr;
				}
				else
				{
					if(BraceFlag)
						CloseBrace(Button);
					else
						Label2->Caption = "";
					FirstOp = true;
					BraceFlag = false;
				}
			}
			break;
		case B_OBRACE:
			if(!BraceFlag)
			{
				BraceFlag = true;
				Str0Flag = true;
				Exponent = false;
				Dozimal = false;
				if(FirstOp)
				{
					BraceNum = 0.0L;
					BraceOpKey = B_PLUS;
				}
				else
				{
					BraceNum = FirstNum;
					BraceOpKey = OpKey;
				}
				ChrtoStr[0] = Button;
				Label2->Caption = ChrtoStr;
				FirstOp = true;
				SecondOp = true;
			}
			break;
		case B_MC:
			Memory = 0.0L;
			Label1->Caption = "";
			break;
		case B_MR:
			if(Memory == 0.0L)
				break;
			Str0Flag = true;
			Exponent = false;
			Dozimal = false;
			DspNum = Memory;
			Memo1->Text = Zen.ftoalb(DspNum, StrMemo, 14);
			SecondOp = true;
			break;
		case B_MSUB: case B_MPLUS:
			Str0Flag = true;
			Exponent = false;
			Dozimal = false;
			if(Button == B_MSUB)
				Memory -= DspNum;
			else
				Memory += DspNum;
			if(Memory)
				Label1->Caption = "M";
			else
				Label1->Caption = "";
			break;
		case B_PI:
			Str0Flag = true;
			Exponent = false;
			Dozimal = false;
			DspNum = M_PI;
			Memo1->Text = Zen.ftoalb(DspNum, StrMemo, 14);
			SecondOp = true;
			break;
		case B_E:
			Str0Flag = true;
			Exponent = false;
			Dozimal = false;
			DspNum = M_E;
			Memo1->Text = Zen.ftoalb(DspNum, StrMemo, 14);
			SecondOp = true;
			break;
		case B_LOG:
			Str0Flag = true;
			Exponent = false;
			Dozimal = false;
			if(DspNum <= 0.0L)
			{
				Memo1->Text = strcpy(StrMemo, "Log Error!");
				break;
			}
			DspNum = log10l(DspNum) / log10l(Zen.getbase());
			Memo1->Text = Zen.ftoalb(DspNum, StrMemo, 14);
			SecondOp = true;
			break;
		case B_ALOG:
			Str0Flag = true;
			Exponent = false;
			Dozimal = false;
			DspNum = powl(Zen.getbase(), DspNum);
			Memo1->Text = Zen.ftoalb(DspNum, StrMemo, 14);
			SecondOp = true;
			break;
		case B_SIN:
			Str0Flag = true;
			Exponent = false;
			Dozimal = false;
			if(IntnatFlag == 0)
				DspNum = sinl(DspNum * (2.0L * M_PI));
			else if(IntnatFlag == 1)
				DspNum = sinl(DspNum * M_PI);
			else if(IntnatFlag == 2)
				DspNum = sinl(DspNum / 360.0L * (2.0L * M_PI));
			else
				DspNum = sinl(DspNum);
			Memo1->Text = Zen.ftoalb(DspNum, StrMemo, 14);
			SecondOp = true;
			break;
		case B_ASIN:
			Str0Flag = true;
			Exponent = false;
			Dozimal = false;
			if(DspNum < -1.0L || DspNum > 1.0L)
			{
				Memo1->Text = strcpy(StrMemo, "Arcsine Error!");
				break;
			}
			if(IntnatFlag == 0)
				DspNum = asinl(DspNum) / (2.0L * M_PI);
			else if(IntnatFlag == 1)
				DspNum = asinl(DspNum) / M_PI;
			else if(IntnatFlag == 2)
				DspNum = asinl(DspNum) * 360.0L / (2.0L * M_PI);
			else
				DspNum = asinl(DspNum);
			Memo1->Text = Zen.ftoalb(DspNum, StrMemo, 14);
			SecondOp = true;
			break;
		case B_COS:
			Str0Flag = true;
			Exponent = false;
			Dozimal = false;
			if(IntnatFlag == 0)
				DspNum = cosl(DspNum * (2.0L * M_PI));
			else if(IntnatFlag == 1)
				DspNum = cosl(DspNum * M_PI);
			else if(IntnatFlag == 2)
				DspNum = cosl(DspNum / 360.0L * (2.0L * M_PI));
			else
				DspNum = cosl(DspNum);
			Memo1->Text = Zen.ftoalb(DspNum, StrMemo, 14);
			SecondOp = true;
			break;
		case B_ACOS:
			Str0Flag = true;
			Exponent = false;
			Dozimal = false;
			if(DspNum < -1.0L || DspNum > 1.0L)
			{
				Memo1->Text = strcpy(StrMemo, "Arccosine Error!");
				break;
			}
			if(IntnatFlag == 0)
				DspNum = acosl(DspNum) / (2.0L * M_PI);
			else if(IntnatFlag == 1)
				DspNum = acosl(DspNum) / M_PI;
			else if(IntnatFlag == 2)
				DspNum = acosl(DspNum) * 360.0L / (2.0L * M_PI);
			else
				DspNum = acosl(DspNum);
			Memo1->Text = Zen.ftoalb(DspNum, StrMemo, 14);
			SecondOp = true;
			break;
		case B_TAN:
			Str0Flag = true;
			Exponent = false;
			Dozimal = false;
			if(IntnatFlag == 0)
				DspNum = tanl(DspNum * (2.0L * M_PI));
			else if(IntnatFlag == 1)
				DspNum = tanl(DspNum * M_PI);
			else if(IntnatFlag == 2)
				DspNum = tanl(DspNum / 360.0L * (2.0L * M_PI));
			else
				DspNum = tanl(DspNum);
			Memo1->Text = Zen.ftoalb(DspNum, StrMemo, 14);
			SecondOp = true;
			break;
		case B_ATAN:
			Str0Flag = true;
			Exponent = false;
			Dozimal = false;
			if(IntnatFlag == 0)
				DspNum = atanl(DspNum) / (2.0L * M_PI);
			else if(IntnatFlag == 1)
				DspNum = atanl(DspNum) / M_PI;
			else if(IntnatFlag == 2)
				DspNum = atanl(DspNum) * 360.0L / (2.0L * M_PI);
			else
				DspNum = atanl(DspNum);
			Memo1->Text = Zen.ftoalb(DspNum, StrMemo, 14);
			SecondOp = true;
			break;
		case B_DEC:
			Str0Flag = true;
			Exponent = false;
			Dozimal = false;
			Memo1->Text = Zen.ftoalb(DspNum, StrMemo, 14);
			break;
		default:
			break;
	}
}
//---------------------------------------------------------------------------
bool TForm1::Operation(char Button)
{
	switch(Button)
	{
		case B_DIV:
			if(SecondNum == 0.0L)
				return(true);
			FirstNum /= SecondNum;
			break;
		case B_MULT:
			FirstNum *= SecondNum;
			break;
		case B_SUB:
			FirstNum -= SecondNum;
			break;
		case B_PLUS:
			FirstNum += SecondNum;
			break;
	}
	return(false);
}
//---------------------------------------------------------------------------
void TForm1::CloseBrace(char Button)
{
	SecondNum = DspNum;
	FirstNum = BraceNum;
	if(Operation(BraceOpKey) == true)
		strcpy(StrMemo, "Divide by zero!");
	else
		Zen.ftoalb(FirstNum, StrMemo, 14);
	DspNum = FirstNum;
	Memo1->Text = StrMemo;
	OpKey = Button;
	ChrtoStr[0] = Button;
	Label2->Caption = ChrtoStr;
}
//---------------------------------------------------------------------------
void TForm1::ModifyMode()
{
	if(DecimalFlag)
	{
		Button37->Caption = "Dec";
		Label4->Caption = "Dec";
		Button13->Caption = ".";
		Button10->Enabled = false;
		Button11->Enabled = false;
		Zen.setbase(10);
		Zen.setbasepoint('.');
	}
	else
	{
		Button37->Caption = "Zen";
		Label4->Caption = "Zen";
		Button13->Caption = ";";
		Button10->Enabled = true;
		Button11->Enabled = true;
		Zen.setbase(12);
		Zen.setbasepoint(';');
	}
	if(IntnatFlag == 0)
	{
		Button38->Caption = "1c";
		Label3->Caption = "1c";
	}
	else if(IntnatFlag == 1)
	{
		Button38->Caption = "TGM";
		Label3->Caption = "TGM";
	}
	else if(IntnatFlag == 2)
	{
		if(DecimalFlag)
		{
			Button38->Caption = "360";
			Label3->Caption = "360";
		}
		else
		{
			Button38->Caption = "260";
			Label3->Caption = "260";
		}
	}
	else
	{
		Button38->Caption = "Rad";
		Label3->Caption = "Rad";
	}
}
//---------------------------------------------------------------------------
void TForm1::ToggleFlag(bool &Flag)
{
	if(Flag)
		Flag = false;
	else
		Flag = true;
}
//---------------------------------------------------------------------------
void TForm1::RotIncFlag(int &Flag, int Limit)
{
	Flag++;
	if(Flag >= Limit)
		Flag = 0;
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Button1Click(TObject *Sender)
{
	Calculate(B_1);
	Button15->SetFocus();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Button2Click(TObject *Sender)
{
	Calculate(B_2);
	Button15->SetFocus();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Button3Click(TObject *Sender)
{
	Calculate(B_3);
	Button15->SetFocus();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Button4Click(TObject *Sender)
{
	Calculate(B_4);
	Button15->SetFocus();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Button5Click(TObject *Sender)
{
	Calculate(B_5);
	Button15->SetFocus();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Button6Click(TObject *Sender)
{
	Calculate(B_6);
	Button15->SetFocus();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Button7Click(TObject *Sender)
{
	Calculate(B_7);
	Button15->SetFocus();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Button8Click(TObject *Sender)
{
	Calculate(B_8);
	Button15->SetFocus();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Button9Click(TObject *Sender)
{
	Calculate(B_9);
	Button15->SetFocus();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Button10Click(TObject *Sender)
{
	Calculate(B_TEN);
	Button15->SetFocus();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Button11Click(TObject *Sender)
{
	Calculate(B_ELV);
	Button15->SetFocus();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Button12Click(TObject *Sender)
{
	Calculate(B_0);
	Button15->SetFocus();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Button13Click(TObject *Sender)
{
	Calculate(B_DOZIMAL);
	Button15->SetFocus();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Button14Click(TObject *Sender)
{
	Calculate(B_MINUS);
	Button15->SetFocus();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Button15Click(TObject *Sender)
{
	Calculate(B_EQUALS);
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Button16Click(TObject *Sender)
{
	Calculate(B_DIV);
	Button15->SetFocus();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Button17Click(TObject *Sender)
{
	Calculate(B_MULT);
	Button15->SetFocus();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Button18Click(TObject *Sender)
{
	Calculate(B_SUB);
	Button15->SetFocus();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Button19Click(TObject *Sender)
{
	Calculate(B_PLUS);
	Button15->SetFocus();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Button20Click(TObject *Sender)
{
	Calculate(B_DEL);
	Button15->SetFocus();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Button21Click(TObject *Sender)
{
	Calculate(B_AC);
	Button15->SetFocus();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Button22Click(TObject *Sender)
{
	Calculate(B_MC);
	Button15->SetFocus();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Button23Click(TObject *Sender)
{
	Calculate(B_MR);
	Button15->SetFocus();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Button24Click(TObject *Sender)
{
	Calculate(B_MSUB);
	Button15->SetFocus();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Button25Click(TObject *Sender)
{
	Calculate(B_MPLUS);
	Button15->SetFocus();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Button26Click(TObject *Sender)
{
	Calculate(B_PI);
	Button15->SetFocus();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Button27Click(TObject *Sender)
{
	Calculate(B_E);
	Button15->SetFocus();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Button28Click(TObject *Sender)
{
	Calculate(B_LOG);
	Button15->SetFocus();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Button29Click(TObject *Sender)
{
	Calculate(B_ALOG);
	Button15->SetFocus();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Button30Click(TObject *Sender)
{
	Calculate(B_SIN);
	Button15->SetFocus();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Button31Click(TObject *Sender)
{
	Calculate(B_ASIN);
	Button15->SetFocus();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Button32Click(TObject *Sender)
{
	Calculate(B_COS);
	Button15->SetFocus();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Button33Click(TObject *Sender)
{
	Calculate(B_ACOS);
	Button15->SetFocus();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Button34Click(TObject *Sender)
{
	Calculate(B_TAN);
	Button15->SetFocus();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Button35Click(TObject *Sender)
{
	Calculate(B_ATAN);
	Button15->SetFocus();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Button36Click(TObject *Sender)
{
	Calculate(B_EXP);
	Button15->SetFocus();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Button37Click(TObject *Sender)
{
	ToggleFlag(DecimalFlag);
	ModifyMode();
	Calculate(B_DEC);
	Button15->SetFocus();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Button38Click(TObject *Sender)
{
	RotIncFlag(IntnatFlag, 4);
	ModifyMode();
	Button15->SetFocus();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Button39Click(TObject *Sender)
{
        Calculate(B_OBRACE);
	Button15->SetFocus();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Button40Click(TObject *Sender)
{
        Calculate(B_CBRACE);
	Button15->SetFocus();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Memo1Click(TObject *Sender)
{
	Button15->SetFocus();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::FormKeyPress(TObject *Sender, char &Key)
{
	switch(Key)
	{
		case B_1: case B_2: case B_3: case B_4:
		case B_5: case B_6: case B_7: case B_8:
		case B_9: case B_0: case B_DOZIMAL: case B_EXP:
		case B_MINUS: case B_DEL: case B_AC: case B_DIV:
		case B_MULT: case B_SUB: case B_PLUS: case B_EQUALS:
		case B_MC: case B_MR: case B_MSUB: case B_MPLUS:
		case B_PI: case B_E: case B_LOG: case B_ALOG:
		case B_SIN: case B_ASIN: case B_COS: case B_ACOS:
		case B_TAN: case B_ATAN: case B_OBRACE: case B_CBRACE:
			Calculate(Key);
			break;
		case '*': case 'X':
			Calculate(B_MULT);
			break;
		case B_TEN: case 'a':
			if(!DecimalFlag)
				Calculate(B_TEN);
			break;
		case B_ELV: case 'b':
			if(!DecimalFlag)
				Calculate(B_ELV);
			break;
		case 'D': case 'd':
			Calculate(B_PLUS);
			break;
		case 'I': case 'i':
			Calculate(B_EXP);
			break;
		case 'W': case 'w':
			Calculate(B_MINUS);
			break;
		case 13:	// 'Enter' for =
			Calculate(B_EQUALS);
			break;
		case B_DECIMAL:
			Calculate(B_DOZIMAL);
			break;
		case 'e':
			Calculate(B_MC);
			break;
		case 'r':
			Calculate(B_MR);
			break;
		case 'm':
			Calculate(B_MSUB);
			break;
		case 'p':
			Calculate(B_MPLUS);
			break;
		case 'l':
			Calculate(B_LOG);
			break;
		case 's':
			Calculate(B_SIN);
			break;
		case 'c':
			Calculate(B_COS);
			break;
		case 't':
			Calculate(B_TAN);
			break;
		case B_DEC: case 'n':
			ToggleFlag(DecimalFlag);
			ModifyMode();
			Calculate(B_DEC);
			break;
		case B_INTNAT: case 'f':
			RotIncFlag(IntnatFlag, 4);
			ModifyMode();
			break;
		case 'K': case 'k':
			Calculate(B_OBRACE);
			break;
		case 11:	// Ctrl-K
			Calculate(B_CBRACE);
			break;
		case B_HINT: case 'h':
			if(HintFlag)
			{
				Button14->ShowHint = false;
				Button19->ShowHint = false;
				Button20->ShowHint = false;
				Button21->ShowHint = false;
				Button22->ShowHint = false;
				Button23->ShowHint = false;
				Button24->ShowHint = false;
				Button25->ShowHint = false;
				Button26->ShowHint = false;
				Button27->ShowHint = false;
				Button28->ShowHint = false;
				Button29->ShowHint = false;
				Button30->ShowHint = false;
				Button31->ShowHint = false;
				Button32->ShowHint = false;
				Button33->ShowHint = false;
				Button34->ShowHint = false;
				Button35->ShowHint = false;
				Button36->ShowHint = false;
				Button37->ShowHint = false;
				Button38->ShowHint = false;
				Button39->ShowHint = false;
				Button40->ShowHint = false;
				HintFlag = false;
			}
			else
			{
				Button14->ShowHint = true;
				Button19->ShowHint = true;
				Button20->ShowHint = true;
				Button21->ShowHint = true;
				Button22->ShowHint = true;
				Button23->ShowHint = true;
				Button24->ShowHint = true;
				Button25->ShowHint = true;
				Button26->ShowHint = true;
				Button27->ShowHint = true;
				Button28->ShowHint = true;
				Button29->ShowHint = true;
				Button30->ShowHint = true;
				Button31->ShowHint = true;
				Button32->ShowHint = true;
				Button33->ShowHint = true;
				Button34->ShowHint = true;
				Button35->ShowHint = true;
				Button36->ShowHint = true;
				Button37->ShowHint = true;
				Button38->ShowHint = true;
				Button39->ShowHint = true;
				Button40->ShowHint = true;
				HintFlag = true;
			}
		default:
			break;
	}
	Key = 0;
}
//---------------------------------------------------------------------------
// End
